/*
 * Decompiled with CFR 0.152.
 */
package afficheur;

import afficheur.Afficheur;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class AfficheurSVG
implements Afficheur {
    private static final char NL = '\n';
    private final StringBuilder contenu = new StringBuilder();

    public AfficheurSVG(String string, String string2, int n, int n2) {
        this.contenu.append("<?xml version='1.0'?>\n");
        this.contenu.append("<!-- Car l'axe des Y est invers\u00e9 en SVG les y sont transform\u00e9s en 10 - y\n");
        this.contenu.append("     Toutes les coordonn\u00e9es sont * 10\n");
        this.contenu.append("-->\n");
        this.contenu.append("<svg xmlns='http://www.w3.org/2000/svg'" + AfficheurSVG.XmlAttribute("version", 1.1) + AfficheurSVG.XmlAttribute("width", n) + AfficheurSVG.XmlAttribute("height", n2) + ">" + '\n');
        this.contenu.append("\t<title>" + string + "</title>" + '\n');
        this.contenu.append("\t<desc>" + string2 + "</desc>" + '\n');
    }

    public AfficheurSVG() {
        this("Figure SVG", "Une figure SVG", 200, 100);
    }

    private static String XmlAttribute(String string, String string2) {
        return " " + string + "=\"" + string2 + "\"";
    }

    private static double ySVG(double d) {
        return 10.0 - d;
    }

    private static String XmlAttribute(String string, double d) {
        return AfficheurSVG.XmlAttribute(string, String.valueOf((int)(d * 10.0)));
    }

    private static String XmlAttribute(String string, int n) {
        return AfficheurSVG.XmlAttribute(string, String.valueOf(n));
    }

    private static String XmlAttribute(String string, Color color) {
        return AfficheurSVG.XmlAttribute(string, "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")");
    }

    private static String str2xml(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }

    @Override
    public void dessinerPoint(double d, double d2, Color color) {
        this.contenu.append("\t<circle" + AfficheurSVG.XmlAttribute("cx", d) + AfficheurSVG.XmlAttribute("cy", AfficheurSVG.ySVG(d2)) + AfficheurSVG.XmlAttribute("r", 2) + AfficheurSVG.XmlAttribute("fill", color) + "/>" + '\n');
    }

    @Override
    public void dessinerLigne(double d, double d2, double d3, double d4, Color color) {
        this.contenu.append("\t<line" + AfficheurSVG.XmlAttribute("x1", d) + AfficheurSVG.XmlAttribute("y1", AfficheurSVG.ySVG(d2)) + AfficheurSVG.XmlAttribute("x2", d3) + AfficheurSVG.XmlAttribute("y2", AfficheurSVG.ySVG(d4)) + AfficheurSVG.XmlAttribute("stroke", color) + "/>" + '\n');
    }

    @Override
    public void dessinerCercle(double d, double d2, double d3, Color color) {
        this.contenu.append("\t<circle" + AfficheurSVG.XmlAttribute("cx", d) + AfficheurSVG.XmlAttribute("cy", AfficheurSVG.ySVG(d2)) + AfficheurSVG.XmlAttribute("r", d3) + AfficheurSVG.XmlAttribute("fill", "none") + AfficheurSVG.XmlAttribute("stroke", color) + "/>" + '\n');
    }

    @Override
    public void dessinerTexte(double d, double d2, String string, Color color) {
        this.contenu.append("\t<text" + AfficheurSVG.XmlAttribute("x", d) + AfficheurSVG.XmlAttribute("y", AfficheurSVG.ySVG(d2)) + AfficheurSVG.XmlAttribute("stroke", color) + ">" + AfficheurSVG.str2xml(string) + "</text>" + '\n');
    }

    public void ecrire() {
        this.ecrire(System.out);
    }

    public void ecrire(OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        printStream.print(this.contenu);
        printStream.println("</svg>");
    }

    public void ecrire(String string) {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(string);
                this.ecrire(fileOutputStream);
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

