/*
 * Decompiled with CFR 0.152.
 */
package afficheur;

import afficheur.Afficheur;
import afficheur.Cercle;
import afficheur.Dessin;
import afficheur.Ligne;
import afficheur.Point;
import afficheur.Texte;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JFrame;

public class Ecran
implements Afficheur {
    private JFrame fenetre;
    private Dessin dessin;
    private int xOrigine;
    private int yOrigine;
    private int facteur;

    public Ecran(String string, int n, int n2, int n3) {
        this.fenetre = new JFrame(string);
        this.xOrigine = n / 4;
        this.yOrigine = n2 * 2 / 3;
        this.facteur = n3;
        this.fenetre.getContentPane().setLayout(new FlowLayout());
        this.dessin = new Dessin(n, n2);
        this.fenetre.getContentPane().add(this.dessin);
        this.fenetre.setDefaultCloseOperation(3);
        this.fenetre.pack();
        this.fenetre.setVisible(true);
    }

    public Ecran(String string, int n, int n2, int n3, int n4, int n5) {
        this(string, n, n2, n3);
        this.fenetre.setLocation(n4, n5);
    }

    public void dessinerAxes() {
        int n;
        Dimension dimension = this.fenetre.getSize();
        Color color = Color.white;
        this.dessinerLigne(-dimension.width / this.facteur, 0.0, dimension.width / this.facteur, 0.0, color);
        this.dessinerLigne(0.0, -dimension.height / this.facteur, 0.0, dimension.height / this.facteur, color);
        for (n = 0; n <= dimension.width / this.facteur; ++n) {
            this.dessinerPoint(n, 0.0, color);
            this.dessinerPoint(-n, 0.0, color);
        }
        for (n = 0; n <= dimension.height / this.facteur; ++n) {
            this.dessinerPoint(0.0, n, color);
            this.dessinerPoint(0.0, -n, color);
        }
    }

    private int X(double d) {
        return (int)((double)this.xOrigine + d * (double)this.facteur);
    }

    private int Y(double d) {
        return (int)((double)this.yOrigine - (double)this.facteur * d);
    }

    private int F(double d) {
        return (int)((double)this.facteur * d);
    }

    @Override
    public void dessinerPoint(double d, double d2, Color color) {
        this.dessin.add(new Point(this.X(d), this.Y(d2), color));
    }

    @Override
    public void dessinerLigne(double d, double d2, double d3, double d4, Color color) {
        this.dessin.add(new Ligne(this.X(d), this.Y(d2), this.X(d3), this.Y(d4), color));
    }

    @Override
    public void dessinerCercle(double d, double d2, double d3, Color color) {
        this.dessin.add(new Cercle(this.X(d), this.Y(d2), this.F(d3), color));
    }

    @Override
    public void dessinerTexte(double d, double d2, String string, Color color) {
        this.dessin.add(new Texte(this.X(d), this.Y(d2), string, color));
    }

    public void effacer() {
        this.dessin.effacer();
    }

    public void rafraichir() {
        this.dessin.repaint();
    }

    public static void main(String[] stringArray) {
        Ecran ecran = new Ecran("testerEcran", 600, 400, 30);
        Color color = Color.black;
        ecran.dessinerAxes();
        ecran.dessinerPoint(0.0, 0.0, Color.green);
        ecran.dessinerLigne(-1.0, -1.0, 3.0, 2.0, Color.yellow);
        ecran.dessinerCercle(3.0, 3.0, 1.5, Color.red);
        ecran.dessinerTexte(3.0, 3.0, "A", Color.blue);
    }
}

