/*
 * Decompiled with CFR 0.152.
 */
package view;

import javax.swing.JLabel;
import model.Modifier;
import model.UmlMethod;
import model.UmlParams;

public class MethodDisplay
extends JLabel {
    private UmlMethod method;

    public MethodDisplay(UmlMethod method) {
        this.method = method;
        this.updateLabel();
    }

    public void updateLabel() {
        String tmp;
        StringBuilder str = new StringBuilder();
        str.append(String.valueOf(this.method.getName()) + "(");
        if (!this.method.getParams().isEmpty()) {
            for (UmlParams attr : this.method.getParams()) {
                str.append(String.valueOf(attr.getName()) + ":" + attr.getType() + ",");
            }
            tmp = str.substring(0, str.length() - 1);
            str.setLength(0);
            str.append(tmp);
        }
        str.append(") : ");
        if (this.method.getReturnType() == null) {
            str.append("void");
        } else {
            str.append(this.method.getReturnType());
        }
        if (!this.method.getModifier().isEmpty()) {
            str.append("\u00a0{");
            for (Modifier m : this.method.getModifier()) {
                str.append(String.valueOf(m.toString()) + ",");
            }
            tmp = String.valueOf(str.substring(0, str.length() - 1)) + "}";
            str.setLength(0);
            str.append(tmp);
        }
        this.setText(str.toString());
    }
}

