/*
 * Decompiled with CFR 0.152.
 */
package controller;

import generator.JavaGenerator;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import model.Modifier;
import model.PrimitiveType;
import model.UmlAttribute;
import model.UmlClass;
import model.UmlCompositionLink;
import model.UmlDiagram;
import model.UmlMethod;
import model.UmlParams;
import model.Visibility;
import view.CompositionRelationDisplay;
import view.UMLObjectDisplay;

public class Launcher {
    public static final String APPLICATION_NAME = "UML7";
    public static final int DEFAULT_WIDTH = 500;
    public static final int DEFAULT_HEIGHT = 300;

    public static void main(String[] argv) {
        UmlDiagram showedDiagram = new UmlDiagram();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        JFrame application = new JFrame(APPLICATION_NAME);
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        JPanel editingArea = new JPanel(layout);
        editingArea.setBackground(Color.WHITE);
        application.setContentPane(editingArea);
        application.setSize(500, 300);
        application.setLocationRelativeTo(null);
        application.setJMenuBar(Launcher.buildApplicationMenuBar(application, showedDiagram));
        Launcher.buildDebugDiagram(editingArea, showedDiagram);
        application.setVisible(true);
    }

    private static JMenuBar buildApplicationMenuBar(JFrame f, UmlDiagram displayedDiagram) {
        JMenu file = new JMenu("File");
        JMenuItem exit = new JMenuItem("Exit");
        JMenuItem generate = new JMenuItem("Generate Diagram");
        exit.addActionListener(e -> f.dispose());
        generate.addActionListener(new ActionListener(displayedDiagram){
            private UmlDiagram diagram;
            {
                this.diagram = umlDiagram;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame jf = new JFrame("Generated code");
                JTextArea codeView = new JTextArea();
                codeView.setEditable(false);
                JScrollPane scrollPane = new JScrollPane(codeView);
                JavaGenerator javagen = new JavaGenerator(this.diagram);
                javagen.generateCode();
                Map<String, String> generation = javagen.getCode();
                StringBuilder displayBuilder = new StringBuilder();
                for (String fileName : generation.keySet()) {
                    displayBuilder.append(String.valueOf(fileName) + ":\n=====\n");
                    displayBuilder.append(String.valueOf(generation.get(fileName)) + "\n=====\n\n");
                }
                codeView.setText(displayBuilder.toString());
                jf.getContentPane().add(scrollPane);
                jf.pack();
                jf.setVisible(true);
            }
        });
        file.add(generate);
        file.addSeparator();
        file.add(exit);
        JMenuBar appBar = new JMenuBar();
        appBar.add(file);
        return appBar;
    }

    private static void buildDebugDiagram(JPanel ea, UmlDiagram showedDiagram) {
        UmlClass c1 = new UmlClass("Classe 1");
        showedDiagram.addUmlElements(c1);
        c1.addAttribute(new UmlAttribute("The_Default_letter", PrimitiveType.CHAR));
        HashSet<Modifier> mod = new HashSet<Modifier>();
        mod.add(Modifier.FINAL);
        mod.add(Modifier.STATIC);
        c1.addMethod(new UmlMethod("A_Method", new HashSet<UmlParams>(), null, Visibility.PUBLIC, mod));
        mod = new HashSet();
        mod.add(Modifier.VOLATILE);
        HashSet<UmlParams> param = new HashSet<UmlParams>();
        param.add(new UmlParams(PrimitiveType.CHAR, "letter"));
        c1.addMethod(new UmlMethod("Another_Method", param, PrimitiveType.INT, Visibility.PUBLIC, mod));
        GridBagConstraints gc1 = new GridBagConstraints();
        gc1.gridx = 0;
        gc1.gridy = 1;
        gc1.fill = 1;
        ea.add((Component)new UMLObjectDisplay(c1), gc1);
        UmlClass c2 = new UmlClass("Entreprise");
        showedDiagram.addUmlElements(c2);
        c2.addAttribute(new UmlAttribute("The_Default_letter", PrimitiveType.CHAR));
        mod = new HashSet();
        mod.add(Modifier.FINAL);
        mod.add(Modifier.STATIC);
        c2.addMethod(new UmlMethod("A_Method", new HashSet<UmlParams>(), null, Visibility.PUBLIC, mod));
        mod = new HashSet();
        mod.add(Modifier.VOLATILE);
        param = new HashSet();
        c2.addMethod(new UmlMethod("getA", param, PrimitiveType.INT, Visibility.PUBLIC, mod));
        GridBagConstraints gc3 = new GridBagConstraints();
        gc3.gridx = 3;
        gc3.gridy = 1;
        gc3.fill = 1;
        ea.add((Component)new UMLObjectDisplay(c2), gc3);
        UmlCompositionLink link = new UmlCompositionLink(c1, c2);
        showedDiagram.addUmlRelations(link);
        GridBagConstraints gc4 = new GridBagConstraints();
        CompositionRelationDisplay relation = new CompositionRelationDisplay(null, null, null);
        gc4.gridx = 1;
        gc4.gridy = 1;
        gc4.ipadx = 100;
        gc4.fill = 1;
        gc4.anchor = 21;
        ea.add((Component)relation, gc4);
    }
}

