/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import model.Modifier;
import model.PrimitiveType;
import model.UmlAttribute;
import model.UmlEnum;
import model.UmlMethod;
import model.Visibility;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UmlEnumTest {
    private UmlEnum umlEnum1;
    private UmlEnum umlEnum2;
    private UmlEnum umlEnum3;
    private UmlEnum umlEnum4;
    private UmlEnum umlEnum5;
    private String value1;
    private String value2;
    private String value3;
    private List<String> values;
    private List<String> values2;
    private UmlMethod umlMethod1;
    private UmlMethod umlMethod2;
    private UmlMethod umlMethod3;
    private UmlAttribute umlAttribute1;
    private UmlAttribute umlAttribute2;
    private UmlAttribute umlAttribute3;
    private Visibility visibility;
    private Visibility visibility2;
    private Modifier modifier1;
    private Modifier modifier2;
    private Set<Modifier> modifiers;
    private Set<Modifier> modifiers2;
    private List<UmlMethod> methods;
    private List<UmlMethod> methods2;
    private List<UmlAttribute> attributes;
    private List<UmlAttribute> attributes2;

    @Before
    public void setUp() {
        this.value1 = "value1";
        this.value2 = "value2";
        this.value3 = "value3";
        this.values = new ArrayList<String>();
        this.values.add(this.value1);
        this.values.add(this.value2);
        this.values.add(this.value3);
        this.values2 = new ArrayList<String>();
        this.values2.add(this.value1);
        this.values2.add(this.value2);
        this.visibility = Visibility.PRIVATE;
        this.visibility2 = Visibility.PACKAGE;
        this.modifier1 = Modifier.FINAL;
        this.modifier2 = Modifier.ABSTRACT;
        this.modifiers = new HashSet<Modifier>();
        this.modifiers.add(this.modifier1);
        this.modifiers.add(this.modifier2);
        this.modifiers2 = new HashSet<Modifier>();
        this.modifiers2.add(this.modifier1);
        this.umlMethod1 = new UmlMethod("method1");
        this.umlMethod2 = new UmlMethod("method2");
        this.umlMethod3 = new UmlMethod("method3");
        this.umlAttribute1 = new UmlAttribute("attribute1", PrimitiveType.INT);
        this.umlAttribute2 = new UmlAttribute("attribute2", PrimitiveType.DOUBLE);
        this.umlAttribute3 = new UmlAttribute("attribute3", PrimitiveType.FLOAT);
        this.methods = new ArrayList<UmlMethod>();
        this.methods.add(this.umlMethod1);
        this.methods.add(this.umlMethod2);
        this.methods.add(this.umlMethod3);
        this.methods2 = new ArrayList<UmlMethod>();
        this.methods2.add(this.umlMethod1);
        this.methods2.add(this.umlMethod2);
        this.attributes = new ArrayList<UmlAttribute>();
        this.attributes.add(this.umlAttribute1);
        this.attributes.add(this.umlAttribute2);
        this.attributes.add(this.umlAttribute3);
        this.attributes2 = new ArrayList<UmlAttribute>();
        this.attributes2.add(this.umlAttribute1);
        this.attributes2.add(this.umlAttribute2);
    }

    @Test
    public void testInitialization1() {
        this.umlEnum1 = new UmlEnum("enum1");
        Assert.assertNotNull((Object)this.umlEnum1);
        Assert.assertTrue((boolean)this.umlEnum1.getName().equals("enum1"));
    }

    @Test
    public void testInitialization2() {
        this.umlEnum2 = new UmlEnum("enum2", this.values);
        Assert.assertNotNull((Object)this.umlEnum2);
        Assert.assertTrue((boolean)this.umlEnum2.getName().equals("enum2"));
        Assert.assertTrue((boolean)this.umlEnum2.getValuesList().equals(this.values));
    }

    @Test
    public void testInitialization3() {
        this.umlEnum3 = new UmlEnum("enum3", this.values, this.methods);
        Assert.assertNotNull((Object)this.umlEnum3);
        Assert.assertTrue((boolean)this.umlEnum3.getName().equals("enum3"));
        Assert.assertTrue((boolean)this.umlEnum3.getValuesList().equals(this.values));
        Assert.assertTrue((boolean)this.umlEnum3.getMethodsList().equals(this.methods));
    }

    @Test
    public void testInitialization4() {
        this.umlEnum4 = new UmlEnum("enum4", this.values, this.methods, this.attributes);
        Assert.assertNotNull((Object)this.umlEnum4);
        Assert.assertTrue((boolean)this.umlEnum4.getName().equals("enum4"));
        Assert.assertTrue((boolean)this.umlEnum4.getValuesList().equals(this.values));
        Assert.assertTrue((boolean)this.umlEnum4.getMethodsList().equals(this.methods));
        Assert.assertTrue((boolean)this.umlEnum4.getAttributesList().equals(this.attributes));
    }

    @Test
    public void testInitialization5() {
        this.umlEnum5 = new UmlEnum("enum5", this.values, this.methods, this.attributes, this.visibility, this.modifiers);
        Assert.assertNotNull((Object)this.umlEnum5);
        Assert.assertTrue((boolean)this.umlEnum5.getName().equals("enum5"));
        Assert.assertTrue((boolean)this.umlEnum5.getValuesList().equals(this.values));
        Assert.assertTrue((boolean)this.umlEnum5.getMethodsList().equals(this.methods));
        Assert.assertTrue((boolean)this.umlEnum5.getAttributesList().equals(this.attributes));
        Assert.assertTrue((boolean)this.umlEnum5.getVisibility().equals((Object)this.visibility));
        Assert.assertTrue((boolean)this.umlEnum5.getModifiers().equals(this.modifiers));
    }

    @Test
    public void testSetName() {
        this.umlEnum1 = new UmlEnum("enum1");
        this.umlEnum1.setName("newName");
        Assert.assertTrue((boolean)this.umlEnum1.getName().equals("newName"));
    }

    @Test
    public void testSetValues() {
        this.umlEnum2 = new UmlEnum("enum2", this.values);
        this.umlEnum2.setValuesList(this.values2);
        Assert.assertTrue((boolean)this.umlEnum2.getValuesList().equals(this.values2));
    }

    @Test
    public void testSetMethods() {
        this.umlEnum3 = new UmlEnum("enum3", this.values, this.methods);
        this.umlEnum3.setMethodsList(this.methods2);
        Assert.assertTrue((boolean)this.umlEnum3.getMethodsList().equals(this.methods2));
    }

    @Test
    public void testSetAttributes() {
        this.umlEnum4 = new UmlEnum("enum4", this.values, this.methods, this.attributes);
        this.umlEnum4.setAttributesList(this.attributes2);
        Assert.assertTrue((boolean)this.umlEnum4.getAttributesList().equals(this.attributes2));
    }

    @Test
    public void testSetVisibilityModifiers() {
        this.umlEnum5 = new UmlEnum("enum5", this.values, this.methods, this.attributes, this.visibility, this.modifiers);
        this.umlEnum5.setVisibility(this.visibility2);
        this.umlEnum5.setModifiers(this.modifiers2);
        Assert.assertTrue((boolean)this.umlEnum5.getVisibility().equals((Object)this.visibility2));
        Assert.assertTrue((boolean)this.umlEnum5.getModifiers().equals(this.modifiers2));
    }

    @Test
    public void testClearModifiers() {
        this.umlEnum5 = new UmlEnum("enum5", this.values, this.methods, this.attributes, this.visibility, this.modifiers);
        this.umlEnum5.clearModifiers();
        Assert.assertTrue((boolean)this.umlEnum5.getModifiers().isEmpty());
    }

    @Test
    public void testAddRemove() {
        this.umlEnum4 = new UmlEnum("enum4", this.values, this.methods, this.attributes);
        this.umlEnum4.removeAttribute(this.umlAttribute1);
        Assert.assertTrue((!this.umlEnum4.getAttributesList().contains(this.umlAttribute1) ? 1 : 0) != 0);
        this.umlEnum4.addAttribute(this.umlAttribute1);
        Assert.assertTrue((boolean)this.umlEnum4.getAttributesList().contains(this.umlAttribute1));
        this.umlEnum4.removeMethod(this.umlMethod1);
        Assert.assertTrue((!this.umlEnum4.getMethodsList().contains(this.umlMethod1) ? 1 : 0) != 0);
        this.umlEnum4.addMethod(this.umlMethod1);
        Assert.assertTrue((boolean)this.umlEnum4.getMethodsList().contains(this.umlMethod1));
        this.umlEnum4.removeValue(this.value1);
        Assert.assertTrue((!this.umlEnum4.getValuesList().contains(this.value1) ? 1 : 0) != 0);
        this.umlEnum4.addValue(this.value1);
        Assert.assertTrue((boolean)this.umlEnum4.getValuesList().contains(this.value1));
    }

    @Test
    public void testGetTypeName() {
        this.umlEnum1 = new UmlEnum("class1");
        Assert.assertTrue((boolean)this.umlEnum1.getTypeName().equals("class1"));
    }
}

