/*
 * Decompiled with CFR 0.152.
 */
package model;

import exception.ExceptionAttribute;
import exception.ExceptionInitialization;
import exception.ExceptionMethode;
import generator.DiagramElementVisitor;
import java.util.List;
import java.util.Set;
import model.Modifier;
import model.UmlAttribute;
import model.UmlMethod;
import model.UmlRefType;
import model.Visibility;

public class UmlInterface
extends UmlRefType {
    public UmlInterface(String name) {
        super(name);
    }

    public UmlInterface(String name, List<UmlMethod> methods) {
        super(name, methods);
    }

    public UmlInterface(String name, List<UmlMethod> methods, List<UmlAttribute> attributes) {
        super(name, methods, attributes);
    }

    public UmlInterface(String name, List<UmlMethod> methods, List<UmlAttribute> attributes, Visibility visibility, Set<Modifier> modifiers) {
        super(name, methods, attributes, visibility, modifiers);
    }

    @Override
    public void addAttribute(UmlAttribute attribute) {
    }

    @Override
    public void addMethod(UmlMethod method) {
    }

    @Override
    public void setAttributesList(List<UmlAttribute> attributesList) {
        super.setAttributesList(attributesList);
    }

    @Override
    public void setMethodsList(List<UmlMethod> methodsList) {
        super.setMethodsList(methodsList);
    }

    private void checkAttribute(UmlAttribute attribute) throws ExceptionAttribute {
        if (attribute.getVisibility() != null && attribute.getVisibility() != Visibility.PUBLIC) {
            throw new ExceptionAttribute("The visibility of the attribute should be public or default");
        }
        if (!(attribute.getModifiers() == null || attribute.getModifiers().size() == 2 && attribute.getModifiers().contains((Object)Modifier.FINAL) && attribute.getModifiers().contains((Object)Modifier.STATIC) || attribute.getModifiers().size() == 1 && (attribute.getModifiers().contains((Object)Modifier.FINAL) || attribute.getModifiers().contains((Object)Modifier.STATIC)))) {
            throw new ExceptionAttribute("The modifier of the attribute should be final static or default");
        }
    }

    private void checkMethod(UmlMethod method) throws ExceptionMethode {
        if (!(method.getModifiers() == null || method.getModifiers().size() == 1 && method.getModifiers().contains((Object)Modifier.ABSTRACT))) {
            throw new ExceptionMethode("The modifier of the method should be final static or default");
        }
        if (method.getVisibility() != null && method.getVisibility() != Visibility.PUBLIC) {
            throw new ExceptionMethode("The visibility of the method should be public or default");
        }
    }

    private void checkVisibility(Visibility visibility) throws ExceptionInitialization {
        if (visibility != null && visibility == Visibility.PUBLIC) {
            throw new ExceptionInitialization("The visibility of the interface should be public or default");
        }
    }

    private void checkModifier(Modifier modifier) throws ExceptionInitialization {
        if (modifier != null && modifier == Modifier.ABSTRACT) {
            throw new ExceptionInitialization("The modifier of the interface should be abstract or default");
        }
    }

    private void checkModifier(Set<Modifier> modifiers) throws ExceptionInitialization {
        if (!(modifiers == null || modifiers.size() == 1 && modifiers.contains((Object)Modifier.ABSTRACT))) {
            throw new ExceptionInitialization("The modifier of the interface should be abstract or default");
        }
    }

    private void checkAttributes(List<UmlAttribute> attributes) throws ExceptionAttribute {
        if (attributes != null) {
            int i = 0;
            while (i < attributes.size()) {
                if (!(attributes.get(i).getModifiers() == null || attributes.get(i).getModifiers().size() == 2 && attributes.get(i).getModifiers().contains((Object)Modifier.FINAL) && attributes.contains((Object)Modifier.STATIC) || attributes.get(i).getModifiers().size() == 1 && (attributes.get(i).getModifiers().contains((Object)Modifier.FINAL) || attributes.contains((Object)Modifier.STATIC)))) {
                    throw new ExceptionAttribute("The modifier of the attribute should be final static or default");
                }
                if (attributes.get(i).getVisibility() != null && attributes.get(i).getVisibility() != Visibility.PUBLIC) {
                    throw new ExceptionAttribute("The visibility of the attribute should be public or default");
                }
                ++i;
            }
        }
    }

    private void checkMethods(List<UmlMethod> methods) throws ExceptionMethode {
        if (methods != null) {
            int i = 0;
            while (i < methods.size()) {
                if (!(methods.get(i).getModifiers() == null || methods.get(i).getModifiers().size() == 1 && methods.get(i).getModifiers().contains((Object)Modifier.ABSTRACT))) {
                    throw new ExceptionMethode("The modifier of the method should be final static or default");
                }
                if (methods.get(i).getVisibility() != null && methods.get(i).getVisibility() != Visibility.PUBLIC) {
                    throw new ExceptionMethode("The visibility of the attribute should be final static or default");
                }
                ++i;
            }
        }
    }

    @Override
    public void accept(DiagramElementVisitor visitor) {
        visitor.visit(this);
    }
}

