/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import model.Modifier;
import model.PrimitiveType;
import model.UmlAttribute;
import model.UmlInterface;
import model.UmlMethod;
import model.Visibility;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UmlInterfaceTest {
    private UmlInterface umlInterface1;
    private UmlInterface umlInterface2;
    private UmlInterface umlInterface3;
    private UmlInterface umlInterface4;
    private UmlMethod umlMethod1;
    private UmlMethod umlMethod2;
    private UmlMethod umlMethod3;
    private UmlAttribute umlAttribute1;
    private UmlAttribute umlAttribute2;
    private UmlAttribute umlAttribute3;
    private Visibility visibility;
    private Visibility visibility2;
    private Modifier modifier1;
    private Modifier modifier2;
    private Set<Modifier> modifiers;
    private Set<Modifier> modifiers2;
    private List<UmlMethod> methods;
    private List<UmlMethod> methods2;
    private List<UmlAttribute> attributes;
    private List<UmlAttribute> attributes2;

    @Before
    public void setUp() {
        this.visibility = Visibility.PRIVATE;
        this.visibility2 = Visibility.PACKAGE;
        this.modifier1 = Modifier.FINAL;
        this.modifier2 = Modifier.ABSTRACT;
        this.modifiers = new HashSet<Modifier>();
        this.modifiers.add(this.modifier1);
        this.modifiers.add(this.modifier2);
        this.modifiers2 = new HashSet<Modifier>();
        this.modifiers2.add(this.modifier1);
        this.umlMethod1 = new UmlMethod("method1");
        this.umlMethod2 = new UmlMethod("method2");
        this.umlMethod3 = new UmlMethod("method3");
        this.umlAttribute1 = new UmlAttribute("attribute1", PrimitiveType.INT);
        this.umlAttribute2 = new UmlAttribute("attribute2", PrimitiveType.DOUBLE);
        this.umlAttribute3 = new UmlAttribute("attribute3", PrimitiveType.FLOAT);
        this.methods = new ArrayList<UmlMethod>();
        this.methods.add(this.umlMethod1);
        this.methods.add(this.umlMethod2);
        this.methods.add(this.umlMethod3);
        this.methods2 = new ArrayList<UmlMethod>();
        this.methods2.add(this.umlMethod1);
        this.methods2.add(this.umlMethod2);
        this.attributes = new ArrayList<UmlAttribute>();
        this.attributes.add(this.umlAttribute1);
        this.attributes.add(this.umlAttribute2);
        this.attributes.add(this.umlAttribute3);
        this.attributes2 = new ArrayList<UmlAttribute>();
        this.attributes2.add(this.umlAttribute1);
        this.attributes2.add(this.umlAttribute2);
    }

    @Test
    public void testInitialization1() {
        this.umlInterface1 = new UmlInterface("interface1");
        Assert.assertNotNull((Object)this.umlInterface1);
        Assert.assertTrue((boolean)this.umlInterface1.getName().equals("interface1"));
    }

    @Test
    public void testInitialization2() {
        this.umlInterface2 = new UmlInterface("interface2", this.methods);
        Assert.assertNotNull((Object)this.umlInterface2);
        Assert.assertTrue((boolean)this.umlInterface2.getName().equals("interface2"));
        Assert.assertTrue((boolean)this.umlInterface2.getMethodsList().equals(this.methods));
    }

    @Test
    public void testInitialization3() {
        this.umlInterface3 = new UmlInterface("interface3", this.methods, this.attributes);
        Assert.assertNotNull((Object)this.umlInterface3);
        Assert.assertTrue((boolean)this.umlInterface3.getName().equals("interface3"));
        Assert.assertTrue((boolean)this.umlInterface3.getMethodsList().equals(this.methods));
        Assert.assertTrue((boolean)this.umlInterface3.getAttributesList().equals(this.attributes));
    }

    @Test
    public void testInitialization5() {
        this.umlInterface4 = new UmlInterface("interface4", this.methods, this.attributes, this.visibility, this.modifiers);
        Assert.assertNotNull((Object)this.umlInterface4);
        Assert.assertTrue((boolean)this.umlInterface4.getName().equals("interface4"));
        Assert.assertTrue((boolean)this.umlInterface4.getMethodsList().equals(this.methods));
        Assert.assertTrue((boolean)this.umlInterface4.getAttributesList().equals(this.attributes));
        Assert.assertTrue((boolean)this.umlInterface4.getVisibility().equals((Object)this.visibility));
        Assert.assertTrue((boolean)this.umlInterface4.getModifiers().equals(this.modifiers));
    }

    @Test
    public void testSetName() {
        this.umlInterface1 = new UmlInterface("interface1");
        this.umlInterface1.setName("newName");
        Assert.assertTrue((boolean)this.umlInterface1.getName().equals("newName"));
    }

    @Test
    public void testSetMethods() {
        this.umlInterface2 = new UmlInterface("interface3", this.methods);
        this.umlInterface2.setMethodsList(this.methods2);
        Assert.assertTrue((boolean)this.umlInterface2.getMethodsList().equals(this.methods2));
    }

    @Test
    public void testSetAttributes() {
        this.umlInterface3 = new UmlInterface("interface3", this.methods, this.attributes);
        this.umlInterface3.setAttributesList(this.attributes2);
        Assert.assertTrue((boolean)this.umlInterface3.getAttributesList().equals(this.attributes2));
    }

    @Test
    public void testSetVisibilityModifiers() {
        this.umlInterface4 = new UmlInterface("interface4", this.methods, this.attributes, this.visibility, this.modifiers);
        this.umlInterface4.setVisibility(this.visibility2);
        this.umlInterface4.setModifiers(this.modifiers2);
        Assert.assertTrue((boolean)this.umlInterface4.getVisibility().equals((Object)this.visibility2));
        Assert.assertTrue((boolean)this.umlInterface4.getModifiers().equals(this.modifiers2));
    }

    @Test
    public void testClearModifiers() {
        this.umlInterface4 = new UmlInterface("interface5", this.methods, this.attributes, this.visibility, this.modifiers);
        this.umlInterface4.clearModifiers();
        Assert.assertTrue((boolean)this.umlInterface4.getModifiers().isEmpty());
    }

    @Test
    public void testAddRemove() {
        this.umlInterface3 = new UmlInterface("interface3", this.methods, this.attributes);
        this.umlInterface3.removeAttribute(this.umlAttribute1);
        Assert.assertTrue((!this.umlInterface3.getAttributesList().contains(this.umlAttribute1) ? 1 : 0) != 0);
        this.umlInterface3.addAttribute(this.umlAttribute1);
        Assert.assertTrue((boolean)this.umlInterface3.getAttributesList().contains(this.umlAttribute1));
        this.umlInterface3.removeMethod(this.umlMethod1);
        Assert.assertTrue((!this.umlInterface3.getMethodsList().contains(this.umlMethod1) ? 1 : 0) != 0);
        this.umlInterface3.addMethod(this.umlMethod1);
    }

    @Test
    public void testGetTypeName() {
        this.umlInterface1 = new UmlInterface("interface1");
        Assert.assertTrue((boolean)this.umlInterface1.getTypeName().equals("interface1"));
    }
}

