/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.HashSet;
import java.util.Set;
import model.Modifier;
import model.UmlEntity;
import model.UmlParams;
import model.UmlType;
import model.Visibility;

public class UmlMethod
extends UmlEntity {
    private Set<UmlParams> params;
    private UmlType returnType;
    private String name;

    public UmlMethod(String name) {
        this.name = name;
        this.params = new HashSet<UmlParams>();
        this.returnType = null;
    }

    public UmlMethod(String name, Set<UmlParams> params, UmlType returnType, Visibility visibility, Set<Modifier> modifiers) {
        super(visibility, modifiers);
        this.name = name;
        this.params = params == null ? new HashSet<UmlParams>() : new HashSet<UmlParams>(params);
        this.returnType = returnType;
    }

    public void addParam(UmlParams param) {
        if (this.params.add(param)) {
            this.setChangedAndNotify();
        }
    }

    public void addParams(Set<UmlParams> params) {
        if (this.params.addAll(params)) {
            this.setChangedAndNotify();
        }
    }

    public void removeParam(UmlParams param) {
        if (this.params.remove(param)) {
            this.setChangedAndNotify();
        }
    }

    public void removeParams(Set<UmlParams> params) {
        if (this.params.removeAll(params)) {
            this.setChangedAndNotify();
        }
    }

    public UmlType getReturnType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public Set<UmlParams> getParams() {
        return this.params;
    }

    public void setName(String name) {
        this.name = name;
        this.setChangedAndNotify();
    }

    public void setReturnType(UmlType returnType) {
        this.returnType = returnType;
        this.setChangedAndNotify();
    }
}

