/*
 * Decompiled with CFR 0.152.
 */
package view;

import javax.swing.JLabel;
import model.Modifier;
import model.UmlAttribute;

public class AttributeDisplay
extends JLabel {
    private UmlAttribute attribute;

    public AttributeDisplay(UmlAttribute attribute) {
        this.attribute = attribute;
        this.updateLabel();
    }

    public UmlAttribute getAttribute() {
        return this.attribute;
    }

    public void updateLabel() {
        StringBuilder str = new StringBuilder();
        switch (this.attribute.getVisibility()) {
            case PUBLIC: {
                str.append("+");
                break;
            }
            case PRIVATE: {
                str.append("-");
                break;
            }
            case PROTECTED: {
                str.append("#");
                break;
            }
            default: {
                str.append("Exception");
            }
        }
        if (!this.attribute.getModifiers().isEmpty()) {
            for (Modifier m : this.attribute.getModifiers()) {
                str.append(String.valueOf(m.toString()) + " ");
            }
        }
        str.append(String.valueOf(this.attribute.getName()) + ": " + this.attribute.getType());
        this.setText(str.toString());
    }
}

