/*
 * Decompiled with CFR 0.152.
 */
package view;

import controller.MethodEditorControler;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import model.Modifier;
import model.UmlMethod;
import model.UmlParams;
import model.Visibility;

public class MethodDisplay
extends JLabel
implements Observer {
    public MethodDisplay(UmlMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Method can't be null");
        }
        method.addObserver(this);
        this.addMouseListener(new MethodEditorControler(method));
        this.updateLabel(method);
    }

    public void updateLabel(UmlMethod method) {
        String tmp;
        StringBuilder str = new StringBuilder();
        if (method.getVisibility() == Visibility.PUBLIC) {
            str.append("+");
        } else if (method.getVisibility() == Visibility.PRIVATE) {
            str.append("-");
        } else if (method.getVisibility() == Visibility.PROTECTED) {
            str.append("#");
        } else {
            str.append("Exception");
        }
        str.append(String.valueOf(method.getName()) + "(");
        if (!method.getParams().isEmpty()) {
            for (UmlParams attr : method.getParams()) {
                str.append(String.valueOf(attr.getName()) + ":" + attr.getType().getTypeName() + ",");
            }
            tmp = str.substring(0, str.length() - 1);
            str.setLength(0);
            str.append(tmp);
        }
        str.append(") : ");
        if (method.getReturnType() == null) {
            str.append("void");
        } else {
            str.append(method.getReturnType().getTypeName());
        }
        if (!method.getModifiers().isEmpty()) {
            str.append("\u00a0{");
            for (Modifier m : method.getModifiers()) {
                str.append(String.valueOf(m.toString()) + ",");
            }
            tmp = String.valueOf(str.substring(0, str.length() - 1)) + "}";
            str.setLength(0);
            str.append(tmp);
        }
        this.setText(str.toString());
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof UmlMethod) {
            this.updateLabel((UmlMethod)o);
        }
    }
}

