/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.UmlAttribute;
import model.UmlEntity;
import model.UmlMethod;
import model.UmlType;

abstract class UmlComponent
extends UmlEntity
implements UmlType {
    private String name;
    private List<UmlMethod> methodsList;
    private List<UmlAttribute> attributesList;

    public UmlComponent(String name) {
        this.name = name;
        this.methodsList = new ArrayList<UmlMethod>();
        this.attributesList = new ArrayList<UmlAttribute>();
    }

    public UmlComponent(String name, List<UmlMethod> methods) {
        this.name = name;
        this.methodsList = new ArrayList<UmlMethod>(methods);
        this.attributesList = new ArrayList<UmlAttribute>();
    }

    public UmlComponent(String name, List<UmlMethod> methods, List<UmlAttribute> attributes) {
        this.name = name;
        this.methodsList = new ArrayList<UmlMethod>(methods);
        this.attributesList = new ArrayList<UmlAttribute>(attributes);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<UmlMethod> getMethodsList() {
        return this.methodsList;
    }

    public void setMethodsList(List<UmlMethod> methodsList) {
        this.methodsList = methodsList;
    }

    public List<UmlAttribute> getAttributesList() {
        return this.attributesList;
    }

    public void setAttributesList(List<UmlAttribute> attributesList) {
        this.attributesList = attributesList;
    }

    public void addMethod(UmlMethod method) {
        this.methodsList.add(method);
    }

    public void addAttribute(UmlAttribute attribute) {
        this.attributesList.add(attribute);
    }

    public void removeMethod(UmlMethod method) {
        this.methodsList.remove(method);
    }

    public void removeAttribute(UmlAttribute attribute) {
        this.attributesList.remove(attribute);
    }
}

