/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.HashSet;
import java.util.Set;
import model.Modifier;
import model.Visibility;

public abstract class UmlEntity {
    private Visibility visibility;
    private Set<Modifier> modifiers;

    public UmlEntity(Visibility visibility, Set<Modifier> modifier) {
        this.visibility = visibility;
        this.modifiers = modifier == null ? new HashSet<Modifier>() : new HashSet<Modifier>(modifier);
    }

    public UmlEntity(Visibility visibility) {
        this(visibility, null);
    }

    public UmlEntity() {
        this.visibility = Visibility.PUBLIC;
        this.modifiers = new HashSet<Modifier>();
    }

    public void addModifier(Modifier modifier) {
        this.modifiers.add(modifier);
    }

    public void clearModifiers() {
        this.modifiers.clear();
    }

    public void removeModifier(Modifier modifier) {
        this.modifiers.remove((Object)modifier);
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Set<Modifier> getModifier() {
        return this.modifiers;
    }

    public void setModifiers(Set<Modifier> modifiers) {
        this.modifiers = new HashSet<Modifier>(modifiers);
    }
}

