/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import model.UmlAttribute;
import model.UmlClass;
import model.UmlMethod;
import view.AttributeDisplay;
import view.MethodDisplay;

public class ClassDisplay
extends JPanel {
    private static final int HIGH = 20;
    private transient UmlClass umlclass;
    private JLabel classname;
    private List<AttributeDisplay> attributes;
    private List<MethodDisplay> methods;
    private int displayweight;
    private int displayhigh;

    public ClassDisplay(UmlClass umlclass) {
        this.umlclass = umlclass;
        this.attributes = new ArrayList<AttributeDisplay>();
        this.methods = new ArrayList<MethodDisplay>();
        this.classname = new JLabel(this.umlclass.getName());
        this.setBackground(Color.white);
        this.setLayout(null);
        this.classname.setBounds(1, 0, 100, 20);
        this.add(this.classname);
        this.update();
    }

    private void update() {
        JLabel ad;
        this.attributes.clear();
        this.methods.clear();
        int count = 0;
        int i = 0;
        while (i < this.umlclass.getAttributesList().size()) {
            count = ((UmlAttribute)this.umlclass.getAttributesList().get(i)).getName().length() > count ? ((UmlAttribute)this.umlclass.getAttributesList().get(i)).getName().length() : count;
            ad = new AttributeDisplay((UmlAttribute)this.umlclass.getAttributesList().get(i));
            ad.setBounds(1, 20 * (1 + i), 100, 20);
            this.add(ad);
            ++i;
        }
        i = 0;
        while (i < this.umlclass.getMethodsList().size()) {
            count = ((UmlMethod)this.umlclass.getMethodsList().get(i)).getName().length() > count ? ((UmlMethod)this.umlclass.getMethodsList().get(i)).getName().length() : count;
            ad = new MethodDisplay((UmlMethod)this.umlclass.getMethodsList().get(i));
            ad.setBounds(1, 20 * (i + this.umlclass.getAttributesList().size() + 1), 100, 20);
            this.add(ad);
            ++i;
        }
        this.displayweight = count * 20;
        this.displayhigh = 20 * (this.umlclass.getAttributesList().size() + this.umlclass.getAttributesList().size() + 1);
        this.display();
    }

    public void display() {
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.drawRect(1, this.displayhigh, this.displayweight, this.displayhigh);
        g.drawLine(1, 20, 40, 20);
        g.drawLine(1, 1 + this.umlclass.getAttributesList().size() * 20, 40, 1 + this.umlclass.getAttributesList().size() * 20);
    }
}

