/*
 * Decompiled with CFR 0.152.
 */
package generator;

import generator.DiagramElementVisitor;
import java.util.HashMap;
import java.util.Map;
import model.Modifier;
import model.UmlAttribute;
import model.UmlClass;
import model.UmlDiagram;
import model.UmlEntity;
import model.UmlEnum;
import model.UmlInterface;
import model.UmlMethod;
import model.UmlParams;
import model.UmlRefType;

public class JavaGenerator
implements DiagramElementVisitor {
    private Map<String, String> code;
    private UmlDiagram diagram;

    public JavaGenerator(UmlDiagram diagram) {
        this.diagram = diagram;
        this.code = new HashMap<String, String>();
    }

    public JavaGenerator() {
        this.diagram = null;
        this.code = new HashMap<String, String>();
    }

    private String convertVisibility(UmlEntity component) {
        String visibility = null;
        switch (component.getVisibility().toString()) {
            case "+": {
                visibility = "public";
                break;
            }
            case "-": {
                visibility = "private";
                break;
            }
            case "#": {
                visibility = "protected";
                break;
            }
            default: {
                visibility = "public";
            }
        }
        return visibility;
    }

    public void generateCode() {
        for (UmlRefType element : this.diagram.getUmlElements()) {
            element.accept(this);
        }
    }

    private String generateAttributes(UmlRefType component) {
        StringBuilder attributeCode = new StringBuilder();
        for (UmlAttribute attribut : component.getAttributesList()) {
            attributeCode.append("\n    " + this.convertVisibility(attribut) + " ");
            if (!attribut.getModifiers().isEmpty()) {
                for (Modifier modifier : attribut.getModifiers()) {
                    attributeCode.append(String.valueOf(modifier.toString()) + " ");
                }
            }
            attributeCode.append(String.valueOf(attribut.getType().getTypeName()) + " " + attribut.getName() + ";\n");
        }
        return attributeCode.toString();
    }

    private String generateMethods(UmlRefType component, boolean generateBody) {
        StringBuilder methodCode = new StringBuilder();
        for (UmlMethod method : component.getMethodsList()) {
            methodCode.append("\n    " + this.convertVisibility(method) + " ");
            if (!method.getModifiers().isEmpty()) {
                for (Modifier modifier : method.getModifiers()) {
                    methodCode.append(String.valueOf(modifier.toString()) + " ");
                }
            }
            if (method.getReturnType() != null) {
                methodCode.append(String.valueOf(method.getReturnType().getTypeName()) + " " + method.getName() + "(");
            } else {
                methodCode.append("void " + method.getName() + "(");
            }
            if (!method.getParams().isEmpty()) {
                for (UmlParams params : method.getParams()) {
                    methodCode.append(String.valueOf(params.getType().getTypeName()) + " " + params.getName() + ", ");
                }
                String tmp = methodCode.substring(0, methodCode.length() - 2);
                methodCode.setLength(0);
                methodCode.append(tmp);
            }
            methodCode.append(")");
            if (generateBody) {
                methodCode.append(" {\n    }\n\n");
                continue;
            }
            methodCode.append(";\n");
        }
        return methodCode.toString();
    }

    @Override
    public void visit(UmlEnum umlEnum) {
        this.generateJavaObject(umlEnum, "enum", true);
    }

    @Override
    public void visit(UmlClass umlClass) {
        boolean generateBody = true;
        for (Modifier modifier : umlClass.getModifiers()) {
            if (!modifier.equals((Object)Modifier.ABSTRACT)) continue;
            generateBody = false;
        }
        this.generateJavaObject(umlClass, "class", generateBody);
    }

    @Override
    public void visit(UmlInterface umlInterface) {
        this.generateJavaObject(umlInterface, "interface", false);
    }

    private void generateJavaObject(UmlRefType component, String refType, boolean generateBody) {
        StringBuilder componentCode = new StringBuilder();
        componentCode.append(String.valueOf(this.convertVisibility(component)) + " ");
        if (!component.getModifiers().isEmpty()) {
            for (Modifier modifier : component.getModifiers()) {
                componentCode.append(String.valueOf(modifier.toString()) + " ");
            }
        }
        componentCode.append(String.valueOf(refType) + " " + component.getName() + " {\n\n");
        if (refType.equals("enum") && !((UmlEnum)component).getValuesList().isEmpty()) {
            for (String attribute : ((UmlEnum)component).getValuesList()) {
                componentCode.append("    " + attribute + ";\n");
            }
            componentCode.append("\n");
        }
        if (!component.getAttributesList().isEmpty()) {
            componentCode.append(String.valueOf(this.generateAttributes(component)) + "\n");
        }
        if (!component.getMethodsList().isEmpty()) {
            componentCode.append(this.generateMethods(component, generateBody));
            if (!generateBody) {
                componentCode.append("\n");
            }
        }
        componentCode.append("}\n");
        this.code.put(String.valueOf(component.getName()) + ".java", componentCode.toString());
    }

    public Map<String, String> getCode() {
        return this.code;
    }

    public void setDiagram(UmlDiagram diagram) {
        this.diagram = diagram;
        this.code = new HashMap<String, String>();
    }
}

