/*
 * Decompiled with CFR 0.152.
 */
package generator;

import generator.JavaGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import model.Modifier;
import model.PrimitiveType;
import model.UmlAttribute;
import model.UmlClass;
import model.UmlDiagram;
import model.UmlEnum;
import model.UmlInterface;
import model.UmlMethod;
import model.UmlParams;
import model.UmlRefType;
import model.Visibility;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaGeneratorTest {
    private JavaGenerator generator;
    private UmlDiagram diagramInterface;
    private UmlDiagram diagramClass;
    private UmlDiagram diagramEnum;
    private UmlDiagram diagramClassEmpty;
    private List<UmlRefType> interfaceDiagramComponents;
    private List<UmlRefType> classDiagramComponents;
    private List<UmlRefType> emptyClassDiagramComponents;
    private List<UmlRefType> enumDiagramComponents;
    private UmlRefType interfaceComponent;
    private UmlRefType classComponent;
    private UmlRefType emptyClassComponent;
    private UmlRefType enumComponent;
    private String code;
    private String result;

    @Before
    public void setUp() {
        HashSet<Modifier> modifierAttribut1 = new HashSet<Modifier>();
        modifierAttribut1.add(Modifier.FINAL);
        modifierAttribut1.add(Modifier.STATIC);
        UmlAttribute attribute1 = new UmlAttribute("CONSTANTE", PrimitiveType.INT, Visibility.PUBLIC, modifierAttribut1);
        UmlAttribute attribute2 = new UmlAttribute("attribut2", PrimitiveType.STRING, Visibility.PUBLIC, null);
        UmlAttribute attribute3 = new UmlAttribute("attribut3", PrimitiveType.DOUBLE, Visibility.PRIVATE, null);
        UmlClass type1 = new UmlClass("type1");
        UmlClass type2 = new UmlClass("type2");
        UmlParams param1 = new UmlParams(type1, "param1");
        UmlParams param2 = new UmlParams(type2, "param2");
        HashSet<UmlParams> paramsMethod1 = new HashSet<UmlParams>();
        paramsMethod1.add(param1);
        paramsMethod1.add(param2);
        HashSet<UmlParams> paramsMethod2 = new HashSet<UmlParams>();
        paramsMethod2.add(param1);
        HashSet<Modifier> modifierMethod3 = new HashSet<Modifier>();
        modifierMethod3.add(Modifier.FINAL);
        UmlMethod method1 = new UmlMethod("method1", paramsMethod1, PrimitiveType.VOID, Visibility.PUBLIC, null);
        UmlMethod method2 = new UmlMethod("method2", paramsMethod2, type1, null, null);
        UmlMethod method3 = new UmlMethod("method3", null, type2, null, modifierMethod3);
        ArrayList<UmlAttribute> attributes = new ArrayList<UmlAttribute>();
        attributes.add(attribute1);
        attributes.add(attribute2);
        attributes.add(attribute3);
        ArrayList<UmlMethod> methods = new ArrayList<UmlMethod>();
        methods.add(method1);
        methods.add(method2);
        methods.add(method3);
        ArrayList<String> valuesEnum = new ArrayList<String>();
        valuesEnum.add("INT");
        valuesEnum.add("DOUBLE");
        valuesEnum.add("STRING");
        this.interfaceComponent = new UmlInterface("Interface", methods, attributes, Visibility.PUBLIC, null);
        this.classComponent = new UmlClass("Class", methods, attributes, Visibility.PUBLIC, null);
        this.emptyClassComponent = new UmlClass("ClassEmpty", new ArrayList<UmlMethod>(), new ArrayList<UmlAttribute>(), Visibility.PUBLIC, null);
        this.enumComponent = new UmlEnum("Enum", valuesEnum, methods, attributes, Visibility.PUBLIC, null);
        this.interfaceDiagramComponents = new ArrayList<UmlRefType>();
        this.interfaceDiagramComponents.add(this.interfaceComponent);
        this.classDiagramComponents = new ArrayList<UmlRefType>();
        this.classDiagramComponents.add(this.classComponent);
        this.emptyClassDiagramComponents = new ArrayList<UmlRefType>();
        this.emptyClassDiagramComponents.add(this.emptyClassComponent);
        this.enumDiagramComponents = new ArrayList<UmlRefType>();
        this.enumDiagramComponents.add(this.enumComponent);
        this.diagramInterface = new UmlDiagram("Diagram Interface", this.interfaceDiagramComponents);
        this.diagramClass = new UmlDiagram("Diagram Class", this.classDiagramComponents);
        this.diagramClassEmpty = new UmlDiagram("Diagram Class Empty", this.emptyClassDiagramComponents);
        this.diagramEnum = new UmlDiagram("Diagram Enum", this.enumDiagramComponents);
        this.generator = new JavaGenerator();
        this.result = null;
        this.code = null;
    }

    @Test
    public void testGenerationInterface() {
        this.result = "public interface Interface {\n\n    public static final int CONSTANTE;\n    public String attribut2;\n    private double attribut3;\n\n    public void method1(type2 param2, type1 param1);\n    public type1 method2(type1 param1);\n    public final type2 method3();\n\n}\n";
        this.generator.setDiagram(this.diagramInterface);
        this.generator.generateCode();
        String code = this.generator.getCode().get("Interface.java");
        Assert.assertEquals((String)"testGenerationInterface : wrong generation", (Object)this.result, (Object)code);
    }

    @Test
    public void testGenerationNormalClass() {
        this.result = "public class Class {\n\n    public static final int CONSTANTE;\n    public String attribut2;\n    private double attribut3;\n\n    public void method1(type2 param2, type1 param1) {\n    }\n\n    public type1 method2(type1 param1) {\n    }\n\n    public final type2 method3() {\n    }\n\n}\n";
        this.generator.setDiagram(this.diagramClass);
        this.generator.generateCode();
        this.code = this.generator.getCode().get("Class.java");
        Assert.assertEquals((String)"testGenerationClass: wrong normal class generation", (Object)this.result, (Object)this.code);
    }

    @Test
    public void testGenerationAbstractClass() {
        this.result = "public abstract class ClassEmpty {\n\n}\n";
        this.emptyClassComponent.addModifier(Modifier.ABSTRACT);
        this.generator.setDiagram(this.diagramClassEmpty);
        this.generator.generateCode();
        this.code = this.generator.getCode().get("ClassEmpty.java");
        System.out.println(this.code);
        Assert.assertEquals((String)"testGenerationClass: wrong abstract class generation", (Object)this.result, (Object)this.code);
    }

    @Test
    public void testGenerationEnum() {
        this.result = "public enum Enum {\n\n    INT;\n    DOUBLE;\n    STRING;\n\n    public static final int CONSTANTE;\n    public String attribut2;\n    private double attribut3;\n\n    public void method1(type1 param1, type2 param2) {\n    }\n\n    public type1 method2(type1 param1) {\n    }\n\n    public final type2 method3() {\n    }\n\n}\n";
        this.generator.setDiagram(this.diagramEnum);
        this.generator.generateCode();
        this.code = this.generator.getCode().get("Enum.java");
        System.out.println(this.code);
        Assert.assertEquals((String)"testGenerationClass: wrong enum generation", (Object)this.result, (Object)this.code);
    }
}

