/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import model.Modifier;
import model.PrimitiveType;
import model.UmlAttribute;
import model.UmlClass;
import model.UmlMethod;
import model.Visibility;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UmlClassTest {
    private UmlClass umlClass1;
    private UmlClass umlClass2;
    private UmlClass umlClass3;
    private UmlClass umlClass4;
    private UmlMethod umlMethod1;
    private UmlMethod umlMethod2;
    private UmlMethod umlMethod3;
    private UmlAttribute umlAttribute1;
    private UmlAttribute umlAttribute2;
    private UmlAttribute umlAttribute3;
    private Visibility visibility;
    private Visibility visibility2;
    private Modifier modifier1;
    private Modifier modifier2;
    private Set<Modifier> modifiers;
    private Set<Modifier> modifiers2;
    private List<UmlMethod> methods;
    private List<UmlMethod> methods2;
    private List<UmlAttribute> attributes;
    private List<UmlAttribute> attributes2;

    @Before
    public void setUp() {
        this.visibility = Visibility.PRIVATE;
        this.visibility2 = Visibility.PACKAGE;
        this.modifier1 = Modifier.FINAL;
        this.modifier2 = Modifier.ABSTRACT;
        this.modifiers = new HashSet<Modifier>();
        this.modifiers.add(this.modifier1);
        this.modifiers.add(this.modifier2);
        this.modifiers2 = new HashSet<Modifier>();
        this.modifiers2.add(this.modifier1);
        this.umlMethod1 = new UmlMethod("method1");
        this.umlMethod2 = new UmlMethod("method2");
        this.umlMethod3 = new UmlMethod("method3");
        this.umlAttribute1 = new UmlAttribute("attribute1", PrimitiveType.INT);
        this.umlAttribute2 = new UmlAttribute("attribute2", PrimitiveType.DOUBLE);
        this.umlAttribute3 = new UmlAttribute("attribute3", PrimitiveType.FLOAT);
        this.methods = new ArrayList<UmlMethod>();
        this.methods.add(this.umlMethod1);
        this.methods.add(this.umlMethod2);
        this.methods.add(this.umlMethod3);
        this.methods2 = new ArrayList<UmlMethod>();
        this.methods2.add(this.umlMethod1);
        this.methods2.add(this.umlMethod2);
        this.attributes = new ArrayList<UmlAttribute>();
        this.attributes.add(this.umlAttribute1);
        this.attributes.add(this.umlAttribute2);
        this.attributes.add(this.umlAttribute3);
        this.attributes2 = new ArrayList<UmlAttribute>();
        this.attributes2.add(this.umlAttribute1);
        this.attributes2.add(this.umlAttribute2);
    }

    @Test
    public void testInitialization1() {
        this.umlClass1 = new UmlClass("class1");
        Assert.assertNotNull((Object)this.umlClass1);
        Assert.assertTrue((boolean)this.umlClass1.getName().equals("class1"));
    }

    @Test
    public void testInitialization2() {
        this.umlClass2 = new UmlClass("class2", this.methods);
        Assert.assertNotNull((Object)this.umlClass2);
        Assert.assertTrue((boolean)this.umlClass2.getName().equals("class2"));
        Assert.assertTrue((boolean)this.umlClass2.getMethodsList().equals(this.methods));
    }

    @Test
    public void testInitialization3() {
        this.umlClass3 = new UmlClass("class3", this.methods, this.attributes);
        Assert.assertNotNull((Object)this.umlClass3);
        Assert.assertTrue((boolean)this.umlClass3.getName().equals("class3"));
        Assert.assertTrue((boolean)this.umlClass3.getMethodsList().equals(this.methods));
        Assert.assertTrue((boolean)this.umlClass3.getAttributesList().equals(this.attributes));
    }

    @Test
    public void testInitialization4() {
        this.umlClass4 = new UmlClass("class4", this.methods, this.attributes, this.visibility, this.modifiers);
        Assert.assertNotNull((Object)this.umlClass4);
        Assert.assertTrue((boolean)this.umlClass4.getName().equals("class4"));
        Assert.assertTrue((boolean)this.umlClass4.getMethodsList().equals(this.methods));
        Assert.assertTrue((boolean)this.umlClass4.getAttributesList().equals(this.attributes));
        Assert.assertTrue((boolean)this.umlClass4.getVisibility().equals((Object)this.visibility));
        Assert.assertTrue((boolean)this.umlClass4.getModifiers().equals(this.modifiers));
    }

    @Test
    public void testSetName() {
        this.umlClass1 = new UmlClass("class1");
        this.umlClass1.setName("newName");
        Assert.assertTrue((boolean)this.umlClass1.getName().equals("newName"));
    }

    @Test
    public void testSetMethods() {
        this.umlClass2 = new UmlClass("class2", this.methods);
        this.umlClass2.setMethodsList(this.methods2);
        Assert.assertTrue((boolean)this.umlClass2.getMethodsList().equals(this.methods2));
    }

    @Test
    public void testSetAttributes() {
        this.umlClass3 = new UmlClass("class3", this.methods, this.attributes);
        this.umlClass3.setAttributesList(this.attributes2);
        Assert.assertTrue((boolean)this.umlClass3.getAttributesList().equals(this.attributes2));
    }

    @Test
    public void testSetVisibilityModifiers() {
        this.umlClass4 = new UmlClass("class4", this.methods, this.attributes, this.visibility, this.modifiers);
        this.umlClass4.setVisibility(this.visibility2);
        this.umlClass4.setModifiers(this.modifiers2);
        Assert.assertTrue((boolean)this.umlClass4.getVisibility().equals((Object)this.visibility2));
        Assert.assertTrue((boolean)this.umlClass4.getModifiers().equals(this.modifiers2));
    }

    @Test
    public void testClearModifiers() {
        this.umlClass4 = new UmlClass("class4", this.methods, this.attributes, this.visibility, this.modifiers);
        this.umlClass4.clearModifiers();
        Assert.assertTrue((boolean)this.umlClass4.getModifiers().isEmpty());
    }

    @Test
    public void testAddRemove() {
        this.umlClass3 = new UmlClass("class3", this.methods, this.attributes);
        this.umlClass3.removeAttribute(this.umlAttribute1);
        Assert.assertTrue((!this.umlClass3.getAttributesList().contains(this.umlAttribute1) ? 1 : 0) != 0);
        this.umlClass3.addAttribute(this.umlAttribute1);
        Assert.assertTrue((boolean)this.umlClass3.getAttributesList().contains(this.umlAttribute1));
        this.umlClass3.removeMethod(this.umlMethod1);
        Assert.assertTrue((!this.umlClass3.getMethodsList().contains(this.umlMethod1) ? 1 : 0) != 0);
        this.umlClass3.addMethod(this.umlMethod1);
        Assert.assertTrue((boolean)this.umlClass3.getMethodsList().contains(this.umlMethod1));
    }

    @Test
    public void testGetTypeName() {
        this.umlClass1 = new UmlClass("class1");
        Assert.assertTrue((boolean)this.umlClass1.getTypeName().equals("class1"));
    }
}

