/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.HashSet;
import java.util.Observable;
import java.util.Set;
import model.Modifier;
import model.Visibility;

public abstract class UmlEntity
extends Observable {
    private Visibility visibility;
    private Set<Modifier> modifiers;

    public UmlEntity(Visibility visibility, Set<Modifier> modifiers) {
        this.visibility = visibility == null ? Visibility.PUBLIC : visibility;
        this.modifiers = modifiers == null ? new HashSet<Modifier>() : new HashSet<Modifier>(modifiers);
    }

    public UmlEntity(Set<Modifier> modifiers) {
        this(null, new HashSet<Modifier>(modifiers));
    }

    public UmlEntity(Visibility visibility) {
        this(visibility, null);
    }

    public UmlEntity() {
        this.visibility = Visibility.PUBLIC;
        this.modifiers = new HashSet<Modifier>();
    }

    public void addModifier(Modifier modifier) {
        if (this.modifiers.add(modifier)) {
            this.setChangedAndNotify();
        }
    }

    public void clearModifiers() {
        if (!this.modifiers.isEmpty()) {
            this.modifiers.clear();
            this.setChangedAndNotify();
        }
    }

    public void removeModifier(Modifier modifier) {
        if (this.modifiers.remove((Object)modifier)) {
            this.setChangedAndNotify();
        }
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
        this.setChangedAndNotify();
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Set<Modifier> modifiers) {
        this.modifiers = new HashSet<Modifier>(modifiers);
        this.setChangedAndNotify();
    }

    protected void setChangedAndNotify() {
        this.setChanged();
        this.notifyObservers();
    }
}

