/*
 * Decompiled with CFR 0.152.
 */
package model;

import generator.DiagramElementVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import model.Modifier;
import model.UmlAttribute;
import model.UmlEntity;
import model.UmlMethod;
import model.UmlType;
import model.Visibility;

public abstract class UmlRefType
extends UmlEntity
implements UmlType {
    private String name;
    private List<UmlMethod> methodsList;
    private List<UmlAttribute> attributesList;

    public UmlRefType(String name) {
        this.name = name;
        this.methodsList = new ArrayList<UmlMethod>();
        this.attributesList = new ArrayList<UmlAttribute>();
    }

    public UmlRefType(String name, List<UmlMethod> methods) {
        this.name = name;
        this.methodsList = methods;
        this.attributesList = new ArrayList<UmlAttribute>();
    }

    public UmlRefType(String name, List<UmlMethod> methods, List<UmlAttribute> attributes) {
        this.name = name;
        this.methodsList = methods;
        this.attributesList = attributes;
    }

    public UmlRefType(String name, List<UmlMethod> methods, List<UmlAttribute> attributes, Visibility visibility, Set<Modifier> modifiers) {
        super(visibility, modifiers);
        this.name = name;
        this.methodsList = methods;
        this.attributesList = attributes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        this.name = name;
        this.setChangedAndNotify();
    }

    public List<UmlMethod> getMethodsList() {
        return this.methodsList;
    }

    public void setMethodsList(List<UmlMethod> methodsList) {
        this.methodsList = methodsList;
        this.setChangedAndNotify();
    }

    public List<UmlAttribute> getAttributesList() {
        return this.attributesList;
    }

    public void setAttributesList(List<UmlAttribute> attributesList) {
        this.attributesList = attributesList;
        this.setChangedAndNotify();
    }

    public void addMethod(UmlMethod method) {
        if (this.methodsList.add(method)) {
            this.setChangedAndNotify();
        }
    }

    public void addAttribute(UmlAttribute attribute) {
        if (this.attributesList.add(attribute)) {
            this.setChangedAndNotify();
        }
    }

    public void removeMethod(UmlMethod method) {
        if (this.methodsList.remove(method)) {
            this.setChangedAndNotify();
        }
    }

    public void removeAttribute(UmlAttribute attribute) {
        if (this.attributesList.remove(attribute)) {
            this.setChangedAndNotify();
        }
    }

    @Override
    public String getTypeName() {
        return this.name;
    }

    public abstract void accept(DiagramElementVisitor var1);
}

