/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import model.UmlInterface;
import view.AttributeDisplay;
import view.MethodDisplay;

public class InterfaceDisplay
extends JPanel {
    private static final int high = 20;
    private UmlInterface umlinterface;
    private JLabel interfacename;
    private ArrayList<AttributeDisplay> attributes;
    private ArrayList<MethodDisplay> methods;
    private int displayweight;
    private int displayhigh;

    public InterfaceDisplay(UmlInterface umlinterface) {
        this.umlinterface = umlinterface;
        this.attributes = new ArrayList();
        this.methods = new ArrayList();
        this.interfacename = new JLabel(this.umlinterface.getName());
        this.setBackground(Color.white);
        this.setLayout(null);
        this.interfacename.setBounds(1, 0, 100, 20);
        this.add(this.interfacename);
        this.update();
    }

    private void update() {
        JLabel ad;
        this.attributes.clear();
        this.methods.clear();
        int count = this.umlinterface.getName().length();
        int i = 0;
        while (i < this.umlinterface.getAttributesList().size()) {
            ad = new AttributeDisplay(this.umlinterface.getAttributesList().get(i));
            count = ad.getText().length() > count ? ad.getText().length() : count;
            ad.setBounds(1, 20 * (1 + i), 100, 20);
            this.add(ad);
            ++i;
        }
        i = 0;
        while (i < this.umlinterface.getMethodsList().size()) {
            ad = new MethodDisplay(this.umlinterface.getMethodsList().get(i));
            count = ad.getText().length() > count ? ad.getText().length() : count;
            ad.setBounds(1, 20 * (i + this.umlinterface.getAttributesList().size() + 1), 100, 20);
            this.add(ad);
            ++i;
        }
        this.displayweight = count * 10;
        this.displayhigh = 20 * (this.umlinterface.getAttributesList().size() + this.umlinterface.getAttributesList().size() + 1);
    }

    public void display() {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int count = 1 + this.umlinterface.getAttributesList().size() + this.umlinterface.getMethodsList().size();
        g.drawRect(1, 1, this.displayweight, this.displayhigh);
        g.drawLine(1, 20, this.displayweight, 20);
        g.drawLine(1, (1 + this.umlinterface.getAttributesList().size()) * 20, this.displayweight, (1 + this.umlinterface.getAttributesList().size()) * 20);
    }
}

