/*
 * Decompiled with CFR 0.152.
 */
package view;

import controller.ClassEditorController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import model.UmlAttribute;
import model.UmlEnum;
import model.UmlMethod;
import model.UmlRefType;
import view.AttributeDisplay;
import view.MethodDisplay;

public class UMLObjectDisplay
extends JPanel
implements Observer {
    private static final HashMap<Class<? extends UmlRefType>, String> stereotypeMap;
    private static final Border umlObjectBorders;
    private JLabel classname;
    private JPanel attributeContainer;
    private JPanel functionContainer;

    static {
        umlObjectBorders = BorderFactory.createLineBorder(new Color(250, 240, 50), 2);
        stereotypeMap = new HashMap();
        stereotypeMap.put(UmlEnum.class, "enum");
    }

    public UMLObjectDisplay(UmlRefType umlobject) {
        if (umlobject == null) {
            throw new IllegalArgumentException("uml object can't be null");
        }
        umlobject.addObserver(this);
        this.buildInnerSwingArchitecture(umlobject);
        this.classname.addMouseListener(new ClassEditorController(umlobject));
        this.updateDisplay(umlobject);
    }

    private void buildInnerSwingArchitecture(UmlRefType umlobject) {
        this.setLayout(new BorderLayout());
        this.setBorder(umlObjectBorders);
        this.classname = new JLabel();
        this.classname.setHorizontalAlignment(0);
        JPanel titleArea = new JPanel(new BorderLayout());
        titleArea.setBorder(umlObjectBorders);
        titleArea.add((Component)this.classname, "Center");
        String stereotype = stereotypeMap.get(umlobject.getClass());
        if (stereotype != null) {
            titleArea.add((Component)new JLabel("<<" + stereotype + ">>"), "North");
        }
        this.add((Component)titleArea, "North");
        JPanel listsContainer = new JPanel(new GridLayout(2, 0));
        listsContainer.setBorder(umlObjectBorders);
        this.attributeContainer = new JPanel();
        this.attributeContainer.setLayout(new BoxLayout(this.attributeContainer, 1));
        this.attributeContainer.setBorder(umlObjectBorders);
        this.functionContainer = new JPanel();
        this.functionContainer.setLayout(new BoxLayout(this.functionContainer, 1));
        this.functionContainer.setBorder(umlObjectBorders);
        listsContainer.add(this.attributeContainer);
        listsContainer.add(this.functionContainer);
        this.add((Component)listsContainer, "Center");
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof UmlRefType) {
            this.updateDisplay((UmlRefType)o);
        }
    }

    private void updateDisplay(UmlRefType uc) {
        this.classname.setText(uc.getName());
        this.attributeContainer.removeAll();
        for (UmlAttribute a : uc.getAttributesList()) {
            this.attributeContainer.add(new AttributeDisplay(a));
        }
        this.functionContainer.removeAll();
        for (UmlMethod m : uc.getMethodsList()) {
            this.functionContainer.add(new MethodDisplay(m));
        }
    }
}

