-- Methodologie de la programmation - Projet 2017/2018
-- Système de gestion de fichiers
-- Edouard Lumet - Gr 1

GENERIC
	TYPE T_elt;
	WITH PROCEDURE Afficher_elt ( Fe : IN T_elt );

PACKAGE P_arbre IS
	TYPE T_arbre IS PRIVATE;

	-- Nom: Initialiser
	-- Sémantique: Initialiser un arbre avec la racine
	-- Paramètres:	Null
	-- Pré-condition: Null
	-- Post-condition: Résultat = Null
	-- Type retour: T_arbre
	FUNCTION Initialiser ( ) RETURN T_arbre ;

	-- Nom: Creer_Noeud
	-- Sémantique: Créer un noeud dans l'arbre initialisé
	-- Paramètres:	Fe (IN) : T_elt -- Élément à insérer dans le noeud créé
	-- Pré-condition:
	-- Post-condition:
	PROCEDURE Creer_Noeud ( Fe : IN T_elt ) ;

	-- Nom: Inserer
	-- Sémantique: Insérer un noeud/élément dans l'arbre
	-- Paramètres:	Fn (IN/OUT) : T_arbre -- Noeud parent de l'élément à insérer
	--				Fe (IN) : T_elt -- Elément à insérer
	-- Pré-condition: Null
	-- Post-condition: Fe est un fils de Fn
	PROCEDURE Inserer ( Fn : IN OUT T_arbre ; Fe : IN T_elt ) ;

	-- Nom: Supprimer
	-- Sémantique: Supprimer un noeud/élément de l'arbre
	-- Paramètres:	Fn (IN/OUT) : T_arbre -- Noeud à supprimer
	-- Pré-condition: Fn existe
	-- Post-condition: Fn n'existe pas
	PROCEDURE Supprimer ( Fn : IN OUT T_arbre ) ;

	-- Nom: Rechercher
	-- Sémantique: Rechercher un noeud/élément de l'arbre
	-- Paramètres:	Fa (IN) : T_arbre -- Arborescence du SGF
	--				Fe (IN) : T_elt -- Element recherché
	-- Pré-condition: Fa n'est pas vide (Null)
	-- Post-condition: Si Fe appartient à Fa, alors retourner Fe. Sinon, retourner Null.
	-- Type retour: T_arbre
	FUNCTION Rechercher ( Fa : IN T_arbre ; Fe : IN T_elt ) RETURN T_arbre ;

	-- Nom: Afficher
	-- Sémantique: Afficher un noeud/élément de l'arbre
	-- Paramètres:	Fa (IN) : T_arbre
	-- Pré-condition:
	-- Post-condition:
	PROCEDURE Afficher ( Fa : IN T_arbre ) ;

	-- Nom: Est_Vide
	-- Sémantique: Vérifier si l'arbre est vide
	-- Paramètres:	Fa (IN) : T_arbre
	-- Pré-condition:
	-- Post-condition:
	-- Type retour: Booléen
	FUNCTION Est_Vide ( Fa : IN T_arbre ) RETURN Boolean ;

PRIVATE

	-- Type arbre implanté à l'aide de listes pour l'arborescence
	TYPE T_noeud;
	TYPE T_arbre IS ACCESS T_noeud;
	TYPE T_liste;
	TYPE T_noeud IS RECORD
		elt: T_elt;
		fils: T_liste;
	END RECORD;
	TYPE T_cell;
	TYPE T_liste IS ACCESS T_cell;
	TYPE T_cell IS RECORD
		elt: T_arbre;
		suiv: T_liste;
	END RECORD;

END P_arbre;