-- Methodologie de la programmation - Projet 2017/2018
-- Système de gestion de fichiers
-- Edouard Lumet - Gr 1

PACKAGE P_interpreteur IS

    -- Nom: Creer_Racine
    -- Sémantique: Créer la racine d'un arbre initialisé (arborescence de base)
    -- Paramètres:  Fa (IN) : T_arbre -- Arbre initialisé
    -- Pré-condition: Fa = Null
    -- Post-condition:
    PROCEDURE Creer_Racine ( Fa : IN T_arbre ) ;

    -- Nom: Rep_Courant
    -- Sémantique: Obtenir le répertoire courant ou répertoire de travail
    -- Paramètres:  Null
    -- Pré-condition:
    -- Post-condition:
    -- Type retour: String
    FUNCTION Rep_Courant ( ) RETURN String ;

    -- Nom: Creer_Fichier
    -- Sémantique: Créer un fichier
    -- Paramètres:  Fchemin (IN) : String -- Nom du fichier à créer
    -- Pré-condition:
    -- Post-condition:
    PROCEDURE Creer_Fichier ( Fchemin : IN String ) ;

    -- Nom: Creer_Repertoire
    -- Sémantique: Créer un répertoire
    -- Paramètres:  Fchemin (IN) : String -- Nom du répertoire à créer
    -- Pré-condition:
    -- Post-condition:
    PROCEDURE Creer_Repertoire ( Fchemin : IN String ) ;

    -- Nom: Change_Courant
    -- Sémantique: Changer le répertoire courant
    -- Paramètres:  Fchemin (IN) : String -- Chemin auquel accéder
    -- Pré-condition:
    -- Post-condition:
    -- Type retour: T_arbre
    FUNCTION Change_Courant ( Fchemin : IN String ) RETURN T_arbre ;

    -- Nom: Afficher_Contenu
    -- Sémantique: Afficher le contenu du répertoire indiqué ou courant si pas d'argument
    -- Paramètres:  Fchemin (IN) : String -- Nom du répertoire dont le contenu est à afficher
    -- Pré-condition:
    -- Post-condition:
    PROCEDURE Afficher_Contenu ( Fchemin : IN String ) ;

    -- Nom: Supprimer_Fichier
    -- Sémantique: Supprimer un fichier
    -- Paramètres:  Fchemin (IN) : String -- Nom du fichier à supprimer
    -- Pré-condition:
    -- Post-condition:
    PROCEDURE Supprimer_Fichier ( Fchemin : IN String ) ;

    -- Nom: Deplacer
    -- Sémantique: Déplacer (ou renommer) un fichier ou un répertoire
    -- Paramètres:  Fchemin_Src (IN) : String -- Nom du fichier/répertoire à déplacer
    --              Fchemin_Dst (IN) : String -- Nouveau nom du fichier/répertoire
    -- Pré-condition:
    -- Post-condition:
    PROCEDURE Deplacer ( Fchemin_Src : IN String ; Fchemin_Dst : IN String ) ;

    -- Nom: Copier
    -- Sémantique: Copier un fichier ou un répertoire
    -- Paramètres:  Fchemin_Src (IN) : String -- Nom du fichier/répertoire à copier
    --              Fchemin_Dst (IN) : String -- Nom du fichier/répertoire copié
    -- Pré-condition:
    -- Post-condition:
    PROCEDURE Copier ( Fchemin_Src : IN String ; Fchemin_Dst : IN String ) ;

PRIVATE

    -- Type énuméré pour la distinction fichier (f) ou répertoire (r)
    TYPE T_enum IS (f,r);

	-- Type fichier/répertoire
	TYPE T_ficrep IS RECORD
		type: T_enum; -- Permet de distinguer fichier ou répertoire
		nom: string(1..50);
		droits: integer;
		taille: integer;
	END RECORD;

END P_interpreteur;