-- Methodologie de la programmation - Projet 2017/2018
-- Système de gestion de fichiers
-- Edouard Lumet - Gr 1
-- FICHIER DE TESTS DU PAQUETAGE P_arbre

WITH Ada.Assertions, Ada.Integer_Text_IO, Ada.Text_IO ;
USE Ada.Assertions, Ada.Integer_Text_IO, Ada.Text_IO ;
WITH P_arbre ;

PROCEDURE test_P_arbre IS

    PACKAGE P_arbre_int IS NEW P_arbre(Integer) ;
    USE P_arbre_int ;

    --- VARIABLES ---

    ptr_vide, un_arbre, un_fils : T_arbre ;
    racine : integer ;

BEGIN

    -- Vérifier si un pointeur est nul ou non
    ptr_vide := Null ;
    assert(Est_Vide(ptr_vide), "ECHEC: la fonction Est_Vide ne retourne pas le résultat attentu") ;

    -- Initialiser un arbre
    un_arbre := Initialiser ;
    assert(Est_Vide(un_arbre), "ECHEC: un_arbre n'est pas vide (Initialiser)") ;

    -- Creer un noeud
    racine := 0 ;
    un_arbre := Creer_Noeud(racine) ;
    assert(Get_Noeud_Elt(un_arbre) = racine, "ECHEC: Get_Noeud_Elt(un_arbre) ne retourne pas racine (Creer_Noeud)") ;

    -- Insérer un élement fils d'un noeud
    Inserer(un_arbre, un_fils) ;
    fils := Get_Noeud_Fils(un_arbre) ;
    assert(Not Est_Vide(fils), "ECHEC: le fils de un_arbre n'existe pas (Inserer)") ;
    assert(fils.all.elt.all.elt = un_fils, "ECHEC: le fils de un_arbre ne contient pas l'élément un_fils (Inserer)") ;

    -- Supprimer un noeud de l'arbre
    Supprimer(fils.all.elt) ;
    assert(Est_Vide(fils.all.elt), "ECHEC: le noeud existe (Supprimer)") ;

END test_P_arbre ;