-- Methodologie de la programmation - Projet 2017/2018
-- Système de gestion de fichiers
-- Edouard Lumet - Gr 1
-- FICHIER DE TESTS DU PAQUETAGE P_sgf

WITH Ada.Assertions, Ada.Integer_Text_IO, Ada.Text_IO ;
USE Ada.Assertions, Ada.Integer_Text_IO, Ada.Text_IO ;
WITH P_sgf ; USE P_sgf ;

PROCEDURE test_P_sgf IS

    chemin, nouv_chemin, nom_elt_courant, chemin_fichier : String ;
    chemin_traite : T_strtab ;
    courant : T_sgf ;
    racine : T_ficrep ;

BEGIN

    -- Découper une chaine contenant un chemin en sous-chaines
    chemin = "/toto/titi/tata" ;
    chemin_traite = Split_Path(chemin) ;
    nouv_chemin = "/" & chemin_traite(1) & "/" & chemin_traite(2) & "/" & chemin_traite(3) ;
    assert(nouv_chemin = chemin, "ECHEC: la chaine reconstituée à partir des sous-chaines est différente de la chaine originale") ;

    -- Modifier le répertoire courant (se déplacer)
    courant := Change_Courant(chemin) ;
    nom_elt_courant := courant.all.elt.all.nom ;
    assert(nom_elt_courant = chemin_traite(3), "ECHEC: le nom de l'élément pointé par courant n'est pas celui indiqué dans le chemin (Change_Courant)") ;

    -- Obtenir le répertoire courant
    assert(Rep_Courant = courant, "ECHEC: Rep_Courant ne retourne pas le pointeur courant") ;

    -- Créer la racine
    courant := Null ;
    courant := Creer_Racine(mon_arbre) ;
    assert(Not Est_Vide(courant), "ECHEC: la racine n'a pas été créée, le pointeur est Null (Creer_Racine)") ;
    assert(courant.all.elt.all.nom = "/", "ECHEC: le noeud créé n'est pas la racine (Creer_Racine)") ;

    -- Créer un fichier sous la racine
    chemin_fichier = "/toto.txt" ;
    Creer_Fichier(chemin_fichier) ;
    assert(Not Est_Vide(courant.all.fils), "ECHEC: le noeud fils n'a pas été créé (Creer_Fichier)") ;
    assert(courant.all.fils.all.elt.all.nom = "toto.txt", "ECHEC: le noeud fils créé n'est pas le fichier toto.txt (Creer_Fichier)") ;

END test_P_sgf ;