-- Edouard LUMET, Groupe GP1
-- R0: Calculer et afficher les nombres premiers compris entre 2 et N par la methode du crible d'Eratosthene. N etant lu au clavier et 2 < N <= Nmax.
-- Tests : Entrée 50, Sortie 2 3 5 7 11 13 17 19 23 29 31 37 41 43 47

with text_io;
use text_io;
with ada.integer_text_io;
use ada.integer_text_io;

Procedure crible Is
	-- Declaration de constante
	Nmax : CONSTANT INTEGER := 200; -- taille maximale du tableau
	-- Declaration des types
	TYPE TAB_BOOL IS ARRAY(1..Nmax) of BOOLEAN; -- tableau d'etats True si nombre de rang i est premier, False sinon
	-- Declaration des variables
	N : INTEGER; -- dernier nombre N a tester lu au clavier et taille effective du tableau
	Un_Tab : TAB_BOOL; -- tableau d'etats de taille N

Begin
	-- R1 Lire N de maniere fiable et conviviale
	LOOP
		PUT("Nmax = ");
		PUT(Nmax);
		NEW_LINE;
		PUT("Saisir un nombre N tel que 2 < N <= Nmax : ");
		GET(N);
	EXIT WHEN N > 2 AND N <= Nmax;
	END LOOP;
	-- 2 < N <= Nmax

	-- R1 Initialiser le tableau
	FOR k in 2 .. N LOOP
		Un_Tab(k) := TRUE;
	END LOOP;
	-- Un_tab initialise a TRUE de 2 a N. Tous les nombres sont premiers jusqu'a preuve du contraire.

	-- R1 Rechercher les nombres premiers
	FOR i IN 2 .. N LOOP
		-- R2 Tester si le nombre n'est pas premier (= a deja ete elimine)
		IF NOT Un_Tab(i) THEN
			NULL;
		ELSE
			FOR j IN i+1 .. N LOOP
				-- R2 Verifier si chaque nombre est divisible par i
				IF j mod i = 0 THEN
					Un_Tab(j) := FALSE;
				ELSE
					NULL;
				END IF;
			END LOOP;
		END IF;
	END LOOP;

	-- R1 Afficher les nombres premiers
	PUT("Les nombres premiers de 2 a N sont :");
	NEW_LINE;
	FOR l IN 2 .. N LOOP
		IF Un_Tab(l) THEN
			PUT(l);
		ELSE
			NULL;
		END IF;
	END LOOP;

End crible;
