-- Edouard LUMET, Groupe GP1
-- R0: Trier les éléments d'un tableau de taille N <= Nmax par la méthode de tri par insertion.
-- Tests

with text_io;
use text_io;
with ada.integer_text_io;
use ada.integer_text_io;

Procedure tri_insertion Is
	-- Declaration de constante
	Nmax : CONSTANT INTEGER := 200; -- taille maximale du tableau
	-- Declaration des types
	TYPE TAB_INT IS ARRAY(1..Nmax) of INTEGER; -- tableau d'entiers de taille max Nmax
	-- Declaration des variables
	N : INTEGER; -- taille effective N du tableau saisie par l'utilisateur
	Un_Tab : TAB_INT; -- tableau lu au clavier, de taille N a trier
	Valeur_Memorisee : INTEGER; -- variable contenant la valeur lue lors du tri
	j : INTEGER;

Begin
	-- R1 Lire N de maniere fiable et conviviale
	LOOP
		PUT("Nmax = ");
		PUT(Nmax);
		NEW_LINE;
		PUT("Saisir un nombre N tel que 1 < N <= Nmax : ");
		GET(N);
	EXIT WHEN N > 1 AND N <= Nmax;
	END LOOP;
	-- 1 < N <= Nmax

	-- R1 Initialiser le tableau
	FOR k in 1 .. N LOOP
		Un_Tab(k) := 0;
	END LOOP;
	PUT("Initialisation du tableau");
	NEW_LINE;
	FOR k in 1 .. N LOOP
		PUT("Saisir un nombre : ");
		GET(Un_Tab(k));
		NEW_LINE;
	END LOOP;

	-- R1 Effectuer tri du tableau
	FOR i IN 2 .. N LOOP
		-- R2 Mémoriser la valeur parcourue Un_Tab(i)
		Valeur_Memorisee := Un_Tab(i);
		-- R2 Deplacer vers la droite les elements du tableau plus grand que celui lu et memorise (Un_Tab(i))
		j := i;
		WHILE j > 1 AND THEN Un_Tab(j - 1) > Valeur_Memorisee LOOP	-- il faut d'abord vérifier que nous ne débordons pas du tableau
			Un_Tab(j) := Un_Tab(j - 1);	-- tant que la valeur précédente est plus grande que la valeur mémorisée, on intervertit les valeurs
			j := j - 1;
		END LOOP;
		-- R2 Inserer la valeur memorisee a l'emplacement libere
		Un_Tab(j) := Valeur_Memorisee;
	END LOOP;

	-- R1 Afficher le tableau trie
	PUT("Le contenu du tableau trie est le suivant :");
	NEW_LINE;
	FOR l IN 1 .. N LOOP
		PUT(Un_Tab(l));
		NEW_LINE;
	END LOOP;

End tri_insertion;
