/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;

public class CallLogCounterBolt
implements IRichBolt {
    Map<String, Integer> counterMap;
    private OutputCollector collector;

    public void prepare(Map map, TopologyContext topologyContext, OutputCollector outputCollector) {
        this.counterMap = new HashMap<String, Integer>();
        this.collector = outputCollector;
    }

    public void execute(Tuple tuple) {
        String string = tuple.getString(0);
        Integer n = tuple.getInteger(1);
        if (!this.counterMap.containsKey(string)) {
            this.counterMap.put(string, 1);
        } else {
            Integer n2 = this.counterMap.get(string) + 1;
            this.counterMap.put(string, n2);
        }
        this.collector.ack(tuple);
    }

    public void cleanup() {
        for (Map.Entry<String, Integer> entry : this.counterMap.entrySet()) {
            System.out.println(entry.getKey() + " : " + entry.getValue());
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
        outputFieldsDeclarer.declare(new Fields(new String[]{"call"}));
    }

    public Map<String, Object> getComponentConfiguration() {
        return null;
    }
}

