/*
 * Decompiled with CFR 0.152.
 */
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.LocalCluster;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.TopologyBuilder;

public class QbouleTopology {
    public static void main(String[] stringArray) {
        try {
            Config config = new Config();
            config.setDebug(true);
            config.setNumWorkers(3);
            TopologyBuilder topologyBuilder = new TopologyBuilder();
            topologyBuilder.setSpout("word-reader", (IRichSpout)new WordReaderSpout());
            topologyBuilder.setBolt("word-counter", (IRichBolt)new WordCountBolt(), (Number)1).shuffleGrouping("word-reader");
            if (stringArray != null && stringArray.length > 0) {
                StormSubmitter.submitTopology((String)"QbouleTopology", (Map)config, (StormTopology)topologyBuilder.createTopology());
            } else {
                System.out.println("Launching in local....");
                LocalCluster localCluster = new LocalCluster();
                localCluster.submitTopology("QbouleTopology", (Map)config, topologyBuilder.createTopology());
                Thread.sleep(10000L);
                localCluster.shutdown();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

