/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Tuple;

public class WordCountBolt
implements IRichBolt {
    Map<String, Integer> counters;
    Integer id;
    String name;
    String fileName;

    public void prepare(Map map, TopologyContext topologyContext, OutputCollector outputCollector) {
        this.counters = new HashMap<String, Integer>();
        this.name = topologyContext.getThisComponentId();
        this.id = topologyContext.getThisTaskId();
    }

    public void execute(Tuple tuple) {
        String string = tuple.getStringByField("word");
        if (!this.counters.containsKey(string)) {
            this.counters.put(string, 1);
        } else {
            this.counters.put(string, this.counters.get(string) + 1);
        }
    }

    public void cleanup() {
        try {
            String string = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
            String string2 = "/tmp/storm-log-" + string + ".log";
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2, true));
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.append("Final word count:::::");
            bufferedWriter.newLine();
            for (Map.Entry<String, Integer> entry : this.counters.entrySet()) {
                bufferedWriter.append(entry.getKey() + "-" + entry.getValue());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
    }

    public Map<String, Object> getComponentConfiguration() {
        return null;
    }
}

